% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHSLS.R
\name{readHSLS}
\alias{readHSLS}
\title{Connect to High School Longitudinal Study 2009 (HSLS:2009) Data}
\usage{
readHSLS(
  path = getwd(),
  filename = "hsls_16_student_v1_0.sav",
  wgtFilename = NA,
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{a character value to the full directory path(s) to the HSLS
extracted SPSS (.sav) set of data files}

\item{filename}{a character value of the name of the SPSS (.sav) datafile to be read}

\item{wgtFilename}{a character value of the name of the associated BRR
weight SPSS (.sav) data file in the specificed \code{path}
to be read.
This argument is only applicable for the restricted-use
student level data, which contains a separate data-file
containing the weight replicate information.
For data files with no balanced
repeated replication (BRR) weight file associated,
specify a value of \code{NULL} or \code{NA}.}

\item{forceReread}{a logic value to force a rereading of all processed data.
The default value of \code{FALSE} speeds up the
\code{readHSLS} function by using existing read-in data
already processed.}

\item{verbose}{a logical value set to \code{TRUE} for verbose output that
indicates progress}
}
\value{
an \code{edsurvey.data.frame} for the HSLS longitudinal dataset
}
\description{
Opens a connection to an HSLS data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the HSLS longitudinal dataset.
}
\note{
The SPSS (.sav) format is preferred over the fixed-width-format (.dat)
ASCII file format at this time relating to value label issues identified
with the ASCII layout specifications.
}
\examples{
\dontrun{
# use function default values at working directory
hsls <- readHSLS("~/HSLS/2009")

# specify parameters with verbose output
hsls <- readHSLS(path="~/HSLS/2009", 
                 filename = "hsls_16_student_v1_0.sav", 
                 forceReread = FALSE, 
                 verbose = TRUE)

# specify parameters silent output
hsls <- readHSLS(path="~/HSLS/2009", 
                 filename = "hsls_16_student_v1_0.sav", 
                 forceReread = FALSE, 
                 verbose = FALSE)

#for restricted-use student data, replicate weights stored in separate file
hslsRUD <- readHSLS(path="~/HSLS/2009", 
                    filename = "hsls_16_student_v1_0.sav", 
                    wgtFilename = "hsls_16_student_BRR_v1_0.sav",
                    forceReread = FALSE, 
                    verbose = TRUE)
}
}
\seealso{
\code{\link{readECLS_K2011}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
