% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploration.R
\name{annotate_hypotheses}
\alias{annotate_hypotheses}
\title{Annotate Hypotheses}
\usage{
annotate_hypotheses(data, hypotheses)
}
\arguments{
\item{data}{Data frame (with exploration results as attribute).}

\item{hypotheses}{Character vector of hypotheses.}
}
\value{
Data frame with hypotheses attached as attribute.
}
\description{
Records researcher hypotheses based on visual exploration, to be used
as constraints or guides in subsequent symbolic search.
}
\examples{
\donttest{
# Toy example
data <- data.frame(Z = 1:10)
data <- annotate_hypotheses(data, c(
  "Z exhibits logistic saturation around Z=100",
  "Effect of X appears linear"
))
}

}
