% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_search.R
\name{symbolic_search}
\alias{symbolic_search}
\title{Symbolic Regression and Equation Discovery}
\usage{
symbolic_search(
  target,
  predictors,
  operators = NULL,
  constraints = NULL,
  n_runs = 5,
  complexity_penalty = 0.05,
  parsimony_pressure = c("adaptive", "constant", "none"),
  backend = c("r_genetic", "julia", "r_exhaustive"),
  julia_options = NULL,
  weights = NULL,
  verbose = TRUE
)
}
\arguments{
\item{target}{Numeric vector of target values (typically derivatives).}

\item{predictors}{Data frame of predictor variables.}

\item{operators}{List specifying allowed operators:
\itemize{
\item binary: c("+", "-", "*", "/")
\item unary: c("exp", "log", "sqrt", "inv", "square")
\item custom: Custom function names (must be defined)
}}

\item{constraints}{List of constraints:
\itemize{
\item forced: Formula of terms that must appear
\item forbidden: Formula of terms that must not appear
\item max_complexity: Maximum expression complexity
}}

\item{n_runs}{Number of independent runs for robustness.}

\item{complexity_penalty}{Penalty per unit complexity.}

\item{parsimony_pressure}{Type of parsimony: "constant", "adaptive", or "none".}

\item{backend}{Computation backend: "julia", "r_genetic", or "r_exhaustive".}

\item{julia_options}{List of options passed to SymbolicRegression.jl.}

\item{weights}{Optional weight vector for weighted regression.}

\item{verbose}{Print progress messages?}
}
\value{
An object of class "symbolic_search_result" containing:
\itemize{
\item pareto_front: Data frame of Pareto-optimal equations
\item all_equations: All discovered equations
\item best_by_complexity: Best equation at each complexity level
\item run_diagnostics: Information about each run
}
}
\description{
Functions for discovering functional forms through symbolic
regression using genetic algorithms. Interfaces with Julia's
SymbolicRegression.jl for advanced search, with fallback to R-native
methods for simpler cases.

Discovers the functional form of a differential equation from data using
genetic/evolutionary algorithms. Returns a Pareto front of equations
trading off complexity against fit.
}
\examples{
\donttest{
# Toy example using R-native exhaustive search (fastest for demo)
data <- data.frame(
  x = seq(1, 10, length.out = 20),
  y = seq(1, 10, length.out = 20)^2 + rnorm(20, sd = 0.1)
)

# Discover y ~ x^2
results <- symbolic_search(
  target = data$y,
  predictors = data["x"],
  backend = "r_exhaustive"
)

print(head(results$pareto_front))
}

}
