% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epinow-internal.R
\name{update_horizon}
\alias{update_horizon}
\title{Updates Forecast Horizon Based on Input Data and Target}
\usage{
update_horizon(horizon, target_date, data)
}
\arguments{
\item{horizon}{Numeric, defaults to 7. Number of days into the future to
forecast.}

\item{target_date}{Date, defaults to maximum found in the data if not
specified.}

\item{data}{A \verb{<data.frame>} of disease reports (confirm) by date (date).
\code{confirm} must be numeric and \code{date} must be in date format. Optionally
this can also have a logical \code{accumulate} column which indicates whether
data should be added to the next data point. This is useful when modelling
e.g. weekly incidence data. See also the \code{\link[=fill_missing]{fill_missing()}} function which
helps add the \code{accumulate} column with the desired properties when dealing
with non-daily data. If any accumulation is done this happens after
truncation as specified by the \code{truncation} argument.}
}
\value{
Numeric forecast horizon adjusted for the users intention
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Makes sure that a forecast is returned for the user specified time period
beyond the target date.
}
\keyword{internal}
