% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{cleanAtlasExport}
\alias{cleanAtlasExport}
\title{Clean the Atlas export dataframe}
\usage{
cleanAtlasExport(x)
}
\arguments{
\item{x}{dataframe, usually the ouput of the import function \code{importAtlasExport(x)}}
}
\value{
dataframe
}
\description{
Clean the Atlas data export dataframe before signal detection analysis \cr
(see \code{\link{importAtlasExport}} and online ECDC Atlas:
\href{https://atlas.ecdc.europa.eu/public/index.aspx}{https://atlas.ecdc.europa.eu/public/index.aspx}) \cr
}
\details{
The function will: \cr
\itemize{
   \item Filter only on case based indicators i.e. 'Reported Cases"
   \item Create four additional time variables to ease the analysis: \cr
   TimeUnit ('Year', 'Month', 'Week'), \cr
   TimeYear (xxxx), \cr
   TimeMonth (xx) \cr
   TimeWeek(xx)
   \item Keep only variables of interest i.e. "HealthTopic", "Population", "Time", "RegionName", "NumValue"
}
}
\examples{
\dontrun{
dataset <- cleanAtlasExport( importAtlasExport(x = 'ECDC_surveillance_data_Anthrax.csv') )
}


}
\seealso{
\code{\link{importAtlasExport}} \code{\link{filterAtlasExport}}
}
