% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runEpiSDApp.R
\name{runEpiSDApp}
\alias{runEpiSDApp}
\title{Run the EpiSignalDectection 'shiny' application}
\usage{
runEpiSDApp()
}
\description{
Run the 'shiny' interactive application for signal detection analysis
using ECDC Atlas export data.
}
\details{
Datasets to use in the tool:
\itemize{
  \item Default dataset included in the application
  (Salmonellosis 2007-2016 or Measles 1999-2018 data);
  \item External dataset using the "Browse" button in the application:
  \itemize{
    \item  --> An export (csv format) from the ECDC Surveillance Atlas of Infectious Diseases:
     \href{https://atlas.ecdc.europa.eu/public/index.aspx}{https://atlas.ecdc.europa.eu/public/index.aspx}.

     On the ECDC "Surveillance Atlas of Infectious Diseases" web site:

    \itemize{
      \item{1-} Choose the disease/health topic to analyse
      \item{2-} Export the data (csv) using the default settings
      \item{3-} Import the csv in the application
      \item{4-} You can now explore the disease time series for signal detection...
    }
    \item --> Any dataset specified as described in the package vignette.
 }
}
}
\examples{
\dontrun{
# --- Run the 'shiny' app
# --- (NB: please open the app in an external browser
# --- in order to facilitate its use)
runEpiSDApp()
}

}
