% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambiental.R
\name{optemp}
\alias{optemp}
\title{Plotting the optimum and cardinal temperatures for crops}
\usage{
optemp(
  VAR,
  crop = NULL,
  verbose = FALSE,
  plot = TRUE,
  ylab = "Meteorological Atribute",
  xlab = "Days After Sowing"
)
}
\arguments{
\item{VAR}{The column with air temperature values (minimum, average or
maximum).}

\item{crop}{Parameter to define the culture. Use 'soybean' for soybean crop,
'maize' for maize crop and 'trit' for wheat crop.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}

\item{plot}{Logical argument. Plot a graph of optimal temperatures if TRUE.}

\item{ylab}{The name of the Y axis.}

\item{xlab}{The name of the X axis.}
}
\value{
Returns the parameters of lower basal and optimum temperature, upper
basal and optimum temperature, maximum temperature and average temperature.
}
\description{
Utility function for plotting graphs of thermal preferences for crops. It is
necessary to inform the  temperature values (minimum, average or maximum).
}
\examples{
library(EstimateBreed)

data("clima")
clima <- get("clima")[1:150, ]

with(clima,optemp(TMED,crop="soybean"))
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
