% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuclideanSD.R
\name{EuclideanSD}
\alias{EuclideanSD}
\title{An Euclidean View of Center and Spread}
\usage{
EuclideanSD(x)
}
\arguments{
\item{x}{It is a data vector that the user feeds. It can be randomly generated.}
}
\value{
A new browser window opens with an interactive graph built by R shiny
  on which the user selects the desired summary statistics with feedback from
  the package until the selections are correct.
}
\description{
This package helps a user guess four things before they get the SD.

  1) The package displays the Empirical Cumulative Distribution Function (ECDF) of
  the given data. The user must choose the value of the mean by equating the areas of
  two colored (blue and green) regions. The package gives feedback to improve the choice
  until it is correct. Alternatively, the reader may continue with a different guess for
  the center (not necessarily the mean).

  2) The user chooses the values of the Mean Deviation (MD) based on the ECDF of the deviations
  by equating the areas of two newly colored (blue and green) regions, with feedback from the
  package until the user guesses correctly.

  3) The user chooses the Scaled Mean Squared Deviation (MSD) based on the ECDF of the scaled
  square deviations by equating the areas of two newly colored (blue and green) regions, with
  feedback from the package until the user guesses correctly.

  4) The user chooses the Root Mean Squared Deviation (RMSD) by ensuring that its intersection
  with the ECDF of the deviations is at the same height as the intersection between the scaled
  MSD and the ECDF of the scaled squared deviations. Additionally, the intersection of two
  blue lines (the green dot) should fall on the vertical line at the maximum deviation.

  5) Finally, if the mean is chosen correctly, only then the user can view the population
  SD (the same as the RMSD) and the sample SD (sqrt(n/(n-1))*RMSD) by clicking the respective
  buttons. If the mean is chosen incorrectly, the user is asked to correct it.
}
\examples{
\donttest{
  data<- c(1,2,3,4,5)
  EuclideanSD(data)
}

\donttest{
  data <- rnorm(90,30,10)
  EuclideanSD(data)
}
}
