/*******************************************************************************
 * Copyright 2025 Observational Health Data Sciences and Informatics
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.ohdsi.data;

/**
 * @author Martijn Schuemie
 */
public class GridWithGradientsData {
	public double[] point;
	public double[] value;
	public double[] derivative;

	public GridWithGradientsData(double[] point, double[] value, double[] derivative) {
		if (point.length < 2)
			throw new IllegalArgumentException("Grid with gradients data must have at least two rows");
		if (value.length != point.length || value.length != point.length) 
			throw new IllegalArgumentException("All dimensions must be equal");
		for (int i = 1; i < point.length; i++) 
			if (point[i-1] > point[i]) 
				throw new IllegalArgumentException("Grid with gradients data must be sorted by point");
		this.point = point;
		this.value = value;
		this.derivative = derivative;
	}
}
