% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_gfft.R
\name{read_fft_df}
\alias{read_fft_df}
\title{Read an FFT definition from tree definitions}
\usage{
read_fft_df(ffts_df, tree = 1)
}
\arguments{
\item{ffts_df}{A set of FFT definitions (as a data frame,
usually from an \code{FFTrees} object,
with suitable variable names to pass \code{verify_ffts_df}.}

\item{tree}{The ID of the to-be-selected FFT (as an integer),
corresponding to a tree in \code{ffts_df}.
Default: \code{tree = 1}.}
}
\value{
One FFT definition
(as a data frame in tidy format, with one row per node).
}
\description{
\code{read_fft_df} reads and returns
the definition of a single FFT (as a tidy data frame)
from the multi-line FFT definitions of an \code{FFTrees} object.

\code{read_fft_df} allows reading individual tree definitions
to manipulate them with other tree trimming functions.

\code{\link{write_fft_df}} provides the inverse functionality.
}
\seealso{
\code{\link{get_fft_df}} for getting the FFT definitions of an \code{FFTrees} object;
\code{\link{write_fft_df}} for writing one FFT to tree definitions;
\code{\link{add_fft_df}} for adding FFTs to tree definitions;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other tree definition and manipulation functions: 
\code{\link{add_fft_df}()},
\code{\link{add_nodes}()},
\code{\link{drop_nodes}()},
\code{\link{edit_nodes}()},
\code{\link{flip_exits}()},
\code{\link{get_fft_df}()},
\code{\link{reorder_nodes}()},
\code{\link{select_nodes}()},
\code{\link{write_fft_df}()}
}
\concept{tree definition and manipulation functions}
