% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfkml.R
\name{SFclust}
\alias{SFclust}
\title{Sparse Fréchet Distance-Based K-medoids for Longitudinal Data}
\usage{
SFclust(k, l1bound, dist.ary, maxIter = 20, eps = 1e-04)
}
\arguments{
\item{k}{The number of clusters.}

\item{l1bound}{A bound on the \eqn{\ell_1} norm for the weight updates. It must lie between 1 and the square root of the number of variables.}

\item{dist.ary}{A 3-dimensional array of pairwise Fréchet distances. The array should be of shape (n, n, p), where \code{n} is the number of trajectories and
\code{p} is the number of variables. Each \code{dist.ary[,,j]} stores the pairwise distances for the \code{j}-th variable.}

\item{maxIter}{The maximum number of iterations before stopping if convergence is not reached. Default is 20.}

\item{eps}{A small positive threshold for convergence. The algorithm stops when the change in weights becomes smaller than this threshold. Default is 1e-4.}
}
\value{
A list containing the following components:
\describe{
\item{clust}{A vector of cluster assignments for each trajectory.}
\item{final.weight}{The final weight vector after the last iteration, reflecting the contribution of each variable to the clustering process.}
\item{weight.history}{A matrix of weight values at each iteration, showing how the feature weights evolved.}
\item{criteria}{A vector of convergence criteria values for each iteration, quantifying the change in weights.}
\item{iteration}{The number of iterations performed before convergence or reaching \code{maxIter}.}
}
}
\description{
Performs clustering on longitudinal trajectories using a sparse feature weighting
scheme and Fréchet distance. The method iteratively updates cluster assignments
and feature weights subject to an \eqn{\ell_1} norm constraint.
}
\details{
The function assumes that the input \code{dist.array} contains pairwise distances between trajectories for each variable,
using the generalized Fréchet distance. Clustering is performed via a k-medoids algorithm,
and feature weights are updated using between-cluster sum of squares (BCSS) with sparsity control.
If the number of variables is one, only clustering is performed, and no variable weighting is applied.
This function involves random sampling internally. For reproducible results, set the random seed before calling the function using \code{set.seed()}.
}
