% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{BERT_download}
\alias{BERT_download}
\title{Download and save BERT models to local cache folder.}
\usage{
BERT_download(models = NULL, verbose = FALSE)
}
\arguments{
\item{models}{A character vector of model names at
\href{https://huggingface.co/models}{HuggingFace}.}

\item{verbose}{Alert if a model has been downloaded.
Defaults to \code{FALSE}.}
}
\value{
Invisibly return a data.table of basic file information of local models.
}
\description{
Download and save BERT models to local cache folder "\%USERPROFILE\%/.cache/huggingface".
}
\examples{
\dontrun{
models = c("bert-base-uncased", "bert-base-cased")
BERT_download(models)

BERT_download()  # check downloaded models

BERT_info()  # information of all downloaded models
}

}
\seealso{
\code{\link[=set_cache_folder]{set_cache_folder()}}

\code{\link[=BERT_info]{BERT_info()}}

\code{\link[=BERT_vocab]{BERT_vocab()}}
}
