% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql_schema.R
\name{llm_bundle_from_db}
\alias{llm_bundle_from_db}
\title{Build an LLM bundle directly from a database table}
\usage{
llm_bundle_from_db(
  conn,
  table,
  n = 30,
  level = c("medium", "low", "high"),
  formats = c("csv", "rds"),
  path = tempdir(),
  filename = "fake_from_db",
  seed = NULL,
  write_prompt = TRUE,
  zip = FALSE,
  zip_filename = NULL,
  sensitive_strategy = c("fake", "drop")
)
}
\arguments{
\item{conn}{A DBI connection.}

\item{table}{Character scalar: table name to read.}

\item{n}{Number of rows in the fake dataset (default 30).}

\item{level}{Privacy level: "low", "medium", or "high". Controls stricter defaults.}

\item{formats}{Which data files to write: any of "csv","rds","parquet".}

\item{path}{Folder to write outputs. Default: \code{tempdir()}.}

\item{filename}{Base file name (no extension). Example: "demo_bundle".
This becomes files like "demo_bundle.csv", "demo_bundle.rds", etc.}

\item{seed}{Optional RNG seed for reproducibility.}

\item{write_prompt}{Write a README_FOR_LLM.txt next to the data? Default TRUE.}

\item{zip}{Create a single zip archive containing data + schema + README? Default FALSE.}

\item{zip_filename}{Optional custom name for the ZIP file (no path).
If \code{NULL} (default), it is derived as \code{paste0(filename, ".zip")},
e.g. \code{"demo_bundle.zip"}.}

\item{sensitive_strategy}{"fake" (replace with realistic fakes) or "drop". Default "fake".}
}
\value{
Invisibly, a list with useful paths:
\itemize{
\item \code{schema_path} – schema JSON
\item \code{files} – vector of written fake-data files
\item \code{zip_path} – zip archive path (if \code{zip = TRUE})
}
}
\description{
Reads just the schema from \code{table} on \code{conn}, synthesizes \code{n} fake rows,
writes a schema JSON, fake dataset(s), and a README prompt, and optionally
zips them into a single archive.
}
\examples{
\donttest{
if (requireNamespace("DBI", quietly = TRUE) &&
    requireNamespace("RSQLite", quietly = TRUE)) {
  con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  on.exit(DBI::dbDisconnect(con), add = TRUE)
  DBI::dbWriteTable(con, "cars", head(cars, 20), overwrite = TRUE)
  out <- llm_bundle_from_db(
    con, "cars",
    n = 100, level = "medium",
    formats = c("csv","rds"),
    path = tempdir(), filename = "db_bundle",
    seed = 1, write_prompt = TRUE, zip = TRUE
  )
}
}

}
