% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureimpcluster.R
\name{FeatureImpCluster}
\alias{FeatureImpCluster}
\title{Feature importance for k-means clustering}
\usage{
FeatureImpCluster(
  clusterObj,
  data,
  basePred = NULL,
  predFUN = NULL,
  sub = 1,
  biter = 10
)
}
\arguments{
\item{clusterObj}{a "typical" cluster object. The only requirement is that there must be a prediction function which maps the data
to an integer}

\item{data}{data.table with the same features as the data set used for clustering (or the simply the same data)}

\item{basePred}{should be equal to results of predFUN(clusterObj,newdata=data); this option saves time when data is a very large data set}

\item{predFUN}{predFUN(clusterObj,newdata=data) should provide the cluster assignment as a numeric vector;
typically this is a wrapper around a build-in prediction function}

\item{sub}{integer between 0 and 1(=default), indicates that only a subset of the data should be used if <1}

\item{biter}{the permutation is iterated biter(=5, default) times}
}
\value{
A list of
\describe{
  \item{misClassRate}{A matrix of the permutation misclassification rate for each variable and each iteration}
  \item{featureImp}{For each row of complete_data, the associated cluster}
}
}
\description{
This function loops through \code{\link{PermMisClassRate}} for each variable of the data.
The mean misclassification rate over all iterations is interpreted as variable importance.
}
\examples{
set.seed(123)
dat <- create_random_data(n=1e3)$data # random data

library(flexclust)
res <- kcca(dat,k=4)
f <- FeatureImpCluster(res,dat)
plot(f)

}
