% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplicative_gxe.R
\name{multi_asr_output}
\alias{multi_asr_output}
\title{Simulate genetic values based on a multiplicative model for GxE interaction -
Simulation with `AlphaSimR`}
\usage{
multi_asr_output(
  pop,
  ntraits = 1,
  nenvs,
  nreps = 1,
  cov.mat,
  return.effects = FALSE
)
}
\arguments{
\item{pop}{An \href{https://CRAN.R-project.org/package=AlphaSimR}{`AlphaSimR`} population object
(\href{https://gaynorr.github.io/AlphaSimR/reference/Pop-class.html}{Pop-class} or
\href{https://gaynorr.github.io/AlphaSimR/reference/HybridPop-class.html}{HybridPop-class})
generated with \link[FieldSimR]{multi_asr_input}.}

\item{ntraits}{Number of traits specified in \link[FieldSimR]{multi_asr_input}.}

\item{nenvs}{Number of environments specified in \link[FieldSimR]{multi_asr_input}.}

\item{nreps}{A vector defining the number of replicates in each environment. If only one value
is specified, all environments will be assigned the same number.}

\item{cov.mat}{A matrix of covariates that will be used to construct the genetic values, typically generated
with \link[FieldSimR]{multi_asr_input}.}

\item{return.effects}{When \code{TRUE} (default is \code{FALSE}), a list is returned with additional
entries containing the genotype slopes for each multiplicative term.}
}
\value{
A data frame with columns 'env', genotype 'id', and 'rep', followed by the
  simulated genetic values for each trait. When \code{return.effects = TRUE}, a list is returned with
  additional entries containing the genotype slopes for each multiplicative term.
}
\description{
Creates a data frame of simulated genetic values in multiple environments for one or more traits
based on a (reduced rank) multiplicative model for genotype-by-environment (GxE) interaction.
This function requires an \href{https://CRAN.R-project.org/package=AlphaSimR}{`AlphaSimR`}
population object generated with \link[FieldSimR]{multi_asr_input}.
}
\examples{
# Simulate genetic values with 'AlphaSimR' for two additive traits in two
# environments based on a multiplicative model with three terms.

# 1. Define the genetic architecture of the simulated traits.
# Mean genetic values.
mean <- c(5, 240) # Trait 1, Trait 2

# Additive genetic variances.
var <- c(0.086, 0.12, 15.1, 8.5) # Trait 1 x 2 environments, Trait 2 x 2 environments

# Additive genetic correlations between the two simulated traits.
TcorA <- matrix(c(
  1.0, 0.6,
  0.6, 1.0
), ncol = 2)

# Additive genetic correlations between the two simulated environments.
EcorA <- matrix(c(
  1.0, 0.2,
  0.2, 1.0
), ncol = 2)

# Construct separable additive genetic correlation matrix
corA <- kronecker(TcorA, EcorA)

input_asr <- multi_asr_input(
  ntraits = 2,
  nenvs = 2,
  mean = mean,
  var = var,
  corA = corA,
  nterms = 3
)


# 2. Use input_asr to simulate genetic values in 'AlphaSimR' based on a
# multiplicative model with three terms.

library("AlphaSimR")
FOUNDERPOP <- quickHaplo(
  nInd = 10,
  nChr = 1,
  segSites = 20
)

SP <- SimParam$new(FOUNDERPOP)

\dontshow{
SP$nThreads <- 1L
}

SP$addTraitA(
  nQtlPerChr = 20,
  mean = input_asr$mean,
  var = input_asr$var,
  corA = input_asr$corA
)

pop <- newPop(FOUNDERPOP)


# 3. Create a data frame with simulated genetic values for the two traits in the two
# environments, with two replicates of each genotype.

# The covariates are obtained from input_asr.

gv_ls <- multi_asr_output(
  pop = pop,
  ntraits = 2,
  nenvs = 2,
  nreps = 2,
  cov.mat = input_asr$cov.mat,
  return.effects = TRUE
)

}
