% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu_bfem.R
\name{simu_bfem}
\alias{simu_bfem}
\title{Experimental setting of the chapter BFEM}
\usage{
simu_bfem(n, which = "Chang1983", ...)
}
\arguments{
\item{n}{Number of observations}

\item{which}{Type of simulation, either:
\itemize{
\item "Chang1983" - Simulate the dataset of Chang's (1983) paper : a mixture of 2 Gaussian with in dimension p=15. 
\item "section4.2" - Experimental setting of Section 4.2: DLM model in dimension p with d=2 and K=3, with noisy dimensions. 
\item "section4.3" - Experimental setting of Section 4.3: Same as `"section4.2"` except the noise is expressed in term of signal-to-noise ration (decibels).
}}

\item{...}{Additional param controlling the simulation
\itemize{
\item p - The desired observed space dimension, the latent dimension is kept fixed to d=2 and noisy Gaussian dimensions are added (useless for `"Chang1983"`) 
\item noise (for `"section4.2"` only) - Variance of the noise 
\item snr (for `"section4.3"` only) - Signal-to-noise ratio (in decibels) representing the ratio of signal and noise variances in logarithmic scale. The greater snr, the smaller noise variance.
}}
}
\value{
A list with slots
\itemize{
\item Y - The simulated data.
\item cls - The true clustering.
}
}
\description{
Experimental setting of the chapter BFEM
}
\examples{
n = 300

# Chang's 1983 setting
simu = simu_bfem(n = n, which = "Chang1983")

# Section 4.2 setting
p = 25
noise = 1
simu = simu_bfem(n, which = "section4.2", p = p, noise = noise)

# Section4.3 setting
snr = 3 # noise variance is 2 times smaller than that of the signal.
simu = simu_bfem(n, which = "section4.3", snr = 10)
}
