% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topdown.R
\name{cstd}
\alias{cstd}
\title{Cross-sectional top-down reconciliation}
\usage{
cstd(base, agg_mat, weights, normalize = TRUE)
}
\arguments{
\item{base}{A (\eqn{h \times 1}) numeric vector containing the top-level base forecast;
\eqn{h} is the forecast horizon.}

\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{weights}{A (\eqn{h \times n_b}) numeric matrix containing the proportions for the
bottom time series; \eqn{h} is the forecast horizon, and \eqn{n_b} is the total number
of bottom variables.}

\item{normalize}{If \code{TRUE} (\emph{default}), the \code{weights} will sum to 1.}
}
\value{
A (\eqn{h \times n}) numeric matrix of cross-sectional reconciled forecasts.
}
\description{
Top-down forecast reconciliation for genuine hierarchical/grouped time series
(Gross and Sohl, 1990), where the forecast of a `Total' (top-level series,
expected to be positive) is disaggregated according to a proportional scheme
(weights). Besides fulfilling any aggregation constraint, the top-down
reconciled forecasts should respect two main properties:
\itemize{
\item the top-level value remains unchanged;
\item all the bottom time series reconciled forecasts are non-negative.
}
}
\examples{
set.seed(123)
# Aggregation matrix for Z = X + Y, X = XX + XY and Y = YX + YY
A <- matrix(c(1,1,1,1,1,1,0,0,0,0,1,1), 3, byrow = TRUE)
# (3 x 1) top base forecasts vector (simulated), forecast horizon = 3
topf <- rnorm(3, 10)
# Same weights for different forecast horizons
fix_weights <- runif(4)
reco <- cstd(base = topf, agg_mat = A, weights = fix_weights)

# Different weights for different forecast horizons
h_weights <- matrix(runif(4*3), 3, 4)
recoh <- cstd(base = topf, agg_mat = A, weights = h_weights)

}
\references{
Gross, C.W. and Sohl, J.E. (1990), Disaggregation methods to expedite product
line forecasting. \emph{Journal of Forecasting} 9(3), 233–254. \doi{10.1002/for.3980090304}
}
\seealso{
Top-down reconciliation: 
\code{\link{cttd}()},
\code{\link{tetd}()}

Cross-sectional framework: 
\code{\link{csboot}()},
\code{\link{csbu}()},
\code{\link{cscov}()},
\code{\link{cslcc}()},
\code{\link{csmo}()},
\code{\link{csrec}()},
\code{\link{cstools}()}
}
\concept{Framework: cross-sectional}
\concept{Reco: top-down}
