% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\name{Gbsg_df}
\alias{Gbsg_df}
\title{Breast Cancer Prognostic Data (German Breast Cancer Study Group)}
\format{
A data frame with 686 observations and 11 variables:
\describe{
  \item{pid}{Patient identifier (integer)}
  \item{age}{Age at diagnosis (integer)}
  \item{meno}{Menopausal status (integer indicator)}
  \item{size}{Tumor size in millimeters (integer)}
  \item{grade}{Tumor grade (integer)}
  \item{nodes}{Number of positive lymph nodes (integer)}
  \item{pgr}{Progesterone receptor level (integer)}
  \item{er}{Estrogen receptor level (integer)}
  \item{hormon}{Hormonal therapy received (integer indicator)}
  \item{rfstime}{Relapse-free survival time in days (integer)}
  \item{status}{Patient status (integer indicator)}
}
}
\source{
Data taken from the survival package version 3.8-3
}
\usage{
data(Gbsg_df)
}
\description{
This dataset, Gbsg_df, provides prognostic factors for breast cancer patients
from the German Breast Cancer Study Group (GBSG). The dataset includes 686
observations and 11 variables, containing information on patient demographics,
tumor characteristics, hormone receptor status, and outcomes. Some observations
contain missing values.
}
\details{
The dataset name has been kept as 'Gbsg_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ForCausality package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not
been modified in any way.
}
