% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INFCvpeSUM.R
\name{INFCvpeSUM}
\alias{INFCvpeSUM}
\alias{INFCvpe_summarise}
\alias{INFCvpe_sum}
\alias{INFCvpe_ConfInt}
\alias{INFCvpe_OutOfDomain}
\title{Estimate tree bole volume or phytomass for stems groups, with associated accuracy info}
\usage{
INFCvpe_summarise(
  in.data,
  EPPOcode_C,
  dbh_C,
  h_tot_C,
  quantity = "vol",
  p = 0.95
)

INFCvpe_sum(EPPOcode, dbh, h_tot, quantity = "vol")

INFCvpe_ConfInt(EPPOcode, dbh, h_tot, quantity = "vol", p = 0.95)

INFCvpe_OutOfDomain(EPPOcode, dbh, h_tot)
}
\arguments{
\item{in.data}{A dataframe (or tibble) containing tally data to be matched with
"EPPOcode_C", "dbh_C" and "htot_C" arguments}

\item{EPPOcode_C}{A string, the name of the column in \code{in.data} with the
species EPPO codes}

\item{dbh_C}{A string, the name of the column in \code{in.data} with the
breast height diameter values}

\item{h_tot_C}{A string, the name of the column in \code{in.data} with the
tree total height values}

\item{quantity}{(default = \code{"vol"}) A character vector specifying required
quantity/ies: \code{c("vol", "dw1" : "dw4")}.
Use \code{Quantities()} to decode definitions.
\itemize{
\item for \code{INFCvpe_summarise()}, if \code{length(unique(quantity)) > 1},
rows in in.data will be replicated for each value.
\item for \code{INFCvpe_SUM functions}, length(quantity) must be 1
}}

\item{p}{(default \code{p = 95\%}) probability used to compute \code{cihw}
(with length = 1 or length = length(dbh))

OPZIONE 2  \code{INFCvpe_SUM functions}:}

\item{EPPOcode}{A character vector with the species EPPO codes
(with length = 1 or length = length(dbh))}

\item{dbh}{A numeric vector with the brest height diameter values}

\item{h_tot}{A numeric vector with the tree total height values
(with length = 1 or length = length(dbh))}
}
\value{
\itemize{
\item \code{INFCvpe_summarise()} returns a dataframe (tibble) with
the grouping columns defined with \code{group_by()}, and the following columns:
\itemize{
\item \code{quantity}: as additional grouping column,
\item \code{n} : number of trees in the group,
\item \code{n_out} : the number of \code{(dbh, htot)} pairs that are 'out of the domain',
\item \code{est} : the estimated value,
\item \code{cihw} : confidence interval half width
\item \code{p}: probability used computing \code{cihw}
}
\item \code{INFCvpe_SUM} - the functions of this family return a numeric vector,
aggregating rows within the same group,
\itemize{
\item \code{INFCvpe_sum()} returns the sum of the estimated quantities,
\item \code{INFCvpe_ConfInt()} returns 'confidence interval half width',
\item \code{INFCvpe_OutOfDomain()} returns the number of 'out of domain'
\code{(dhb, h_tot)} pairs included in the summation
}
}
}
\description{
Cumulative estimation of the volume or phytomass of groups of trees is just
the summation of the values computed with \code{INFCvpe()}, but the computation of
accuracy estimates is improved using these summation functions.\cr
Two approaches are available.
\itemize{
\item Via \code{INFCvpe_summarise()} that processes and returns a data frame
\item or by following aggregation functions within a standard \code{summarise()}:
\itemize{
\item \code{INFCvpe_sum()}
\item \code{INFCvpe_ConfInt()}
\item \code{INFCvpe_OutOfDomain()}
}
}
}
\details{
Functions developed following Tabacchi et al. (2011), pages 23-26.
}
\examples{
\dontrun{
Sezione <- function(EPPOcodes){
  # retrieve 'Sezione' name, decoding EPPO codes
  INFCspecies \%>\% 
    dplyr::filter(EPPOcode \%in\% EPPOcodes) \%>\%
    dplyr::left_join(INFCcatalog,by = "pag")\%>\% 
    dplyr::select(section) \%>\% 
    purrr::pluck(1)
}

tst <- ForIT_test_data \%>\%
  dplyr::filter(UC != "U0") 
# select Tabachi et al. example data

tst \%>\%
  dplyr::group_by(specie) \%>\%
  INFCvpe_summarise("specie", "d130", "h_dendro") \%>\%
  dplyr::ungroup() \%>\%
  dplyr::mutate(specie = Sezione(specie),
                dplyr::across(c("est", "cihw"), ~round(.x, 1))
  ) \%>\%
  dplyr::select(specie, est, cihw) \%>\%
  dplyr::arrange(specie) \%>\%
  dplyr::slice(2, 1, 3) \%>\% 
  t() \%>\% 
  provideDimnames(base = list(dimnames(.)[[1]], ""), unique=FALSE)
# Compare ForIT (ver 2) output
## specie "Aceri"  "Abete bianco" "Faggio"
## est    "4623.0" "4044.2"       "1079.4"
## cihw   "567.5"  "661.2"        "275.4" 
# with 'Tabella 2' in Tabacchi et al. (2011, pag. 27)
## specie "aceri"  "abete bianco" "faggio"
## est    "4623.0" "4044.2"       "1079.4"
## cihw   "567.4"  "662.4"        "279.2"

# Using 'INFCvpe_summarise()'

## Overall totals
tst \%>\%
  INFCvpe_summarise("specie", "d130", "h_dendro", quantity = c("vol", "dw4"))

## Group by dbh class ('cld')
tst \%>\%
  dplyr::mutate(cld = ceiling(d130/5)*5) \%>\%
  dplyr::group_by(UC, specie, cld) \%>\%
  INFCvpe_summarise("specie", "d130", "h_dendro")

## Group by sampling unit ('UC')
tst \%>\%
  dplyr::group_by(UC) \%>\%
  INFCvpe_summarise("specie", "d130", "h_dendro", quantity = "dw4")

# Using 'INFCvpeSUM' aggregation functions

## Esitmate 'dw4' phytomass, by sampling unit ('UC')
tst \%>\%
  dplyr::group_by(UC) \%>\%
  dplyr::summarise(
    n_stems = dplyr::n(),
    OoD = INFCvpe_OutOfDomain(specie, d130, h_dendro),
    dw4 = INFCvpe_sum(specie, d130, h_dendro, quantity = "dw4"),
    dw4_ConfInt = INFCvpe_ConfInt(specie, d130, h_dendro, quantity = "dw4")
  )

## Esitmate volume, by sampling unit ('UC')
tst \%>\%
  dplyr::group_by(UC) \%>\%
  dplyr::summarise(
    n_stems = dplyr::n(),
    OoD = INFCvpe_OutOfDomain(specie, d130, h_dendro),
    vol = INFCvpe_sum(specie, d130, h_dendro),
    vol_ConfInt = INFCvpe_ConfInt(specie, d130, h_dendro)
  )

rm(tst, Sezione)
}
}
\seealso{
\code{\link[=INFCvpe]{INFCvpe()}} to compute individual estimates, with detailed accuracy evaluation
}
