% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand_diameters_and_heights.R
\name{h_dom_weise}
\alias{h_dom_weise}
\title{Weise's Dominant Height}
\usage{
h_dom_weise(h, d, n_rep = 1)
}
\arguments{
\item{h}{vector of tree height values to calculate Weise's dominant height
from}

\item{d}{vector of stem diameters at breast height corresponding to h, must
therefore have the same length as h}

\item{n_rep}{vector of representation numbers (typically the number of trees
per ha corresponding to the diameter at the same position), will be used as
individual weights for each height, together with the squared diameters d.
If n_rep has length 1, it will be recycled to the length of d. Otherwise,
if the length of n_rep does not correspond to the length of d, the function
will terminate with an error.}
}
\value{
The value of Weise's dominant diameter resulting from the input data
}
\description{
The dominant height after Weise is the quadratic mean height of the 20\%
biggest trees in a stand. In contrast to the dominant height
\code{\link{h_100}} it is well defined not only in monospecific stands, but
also in mixed stands.
}
\examples{
# A sample of trees from an angle count sample , where each
# tree represents a basal area of 4 m²/ha
d_cm <- c(12, 13, 25, 27, 28, 26, 26.1, 32, 35, 31, 42)
n_rep_ha <- 4 / ((d_cm / 100)^2 * pi / 4) # representation number of each tree
dq_cm <- d_q(d_cm, n_rep_ha)
h_m <- 0.9 * dq_cm * (d_cm / dq_cm)^0.8 # quick plausible height estim.
h_dom_weise(h_m, d_cm, n_rep_ha)
h_100(h_m, d_cm, n_rep_ha) # dominant height h100 for comparison
h_q(h_m, d_cm) # quadratic mean height for comparison

# if 20\% of the trees are 100 stems/ha, Weise's dominant diameter and
# d100 are equal
d_cm <- rnorm(n = 500, mean = 35, sd = 7)
dq_cm <- d_q(d_cm)
h_m <- 0.8 * dq_cm * (d_cm / dq_cm)^0.8 # quick plausible height estim.
h_dom_weise(h_m, d_cm, 1)
h_100(h_m, d_cm, 1)

# Weise's dominant diameter is greater than d100, if 20\% of the trees
# represent less than 100 trees/ha
d_cm <- rnorm(n = 200, mean = 35, sd = 7)
dq_cm <- d_q(d_cm)
h_m <- 0.8 * dq_cm * (d_cm / dq_cm)^0.8 # quick plausible height estim.
h_dom_weise(h_m, d_cm, 1)
h_100(h_m, d_cm, 1)

# Weise's dominant diameter is smaller than d100, if 20\% of the trees
# represent more than 100 trees/ha
d_cm <- rnorm(n = 800, mean = 35, sd = 7)
dq_cm <- d_q(d_cm)
h_m <- 0.8 * dq_cm * (d_cm / dq_cm)^0.8 # quick plausible height estim.
h_dom_weise(h_m, d_cm, 1)
h_100(h_m, d_cm, 1)

}
\seealso{
Other stand heights: 
\code{\link{h_100}()},
\code{\link{h_q}()},
\code{\link{h_q_from_d_q}()}
}
\concept{stand heights}
