% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_ger_nfi_2012.R
\name{summary.fe_species_ger_nfi_2012}
\alias{summary.fe_species_ger_nfi_2012}
\title{Summary of an \strong{fe_species_ger_nfi_2012} Vector}
\usage{
\method{summary}{fe_species_ger_nfi_2012}(
  object,
  spec_lang = options("fe_spec_lang")$fe_spec_lang,
  maxsum = 100L,
  ...
)
}
\arguments{
\item{object}{Object of class \code{\link{fe_species_ger_nfi_2012}}}

\item{spec_lang}{Choice of how species (group) names or id's are displayed in
the summary. Supported choices are "code" (displays the species codes as
they are), "eng" (English species names), "ger" (German species names), and
"sci" (scientific species names). The names and the codes refer to the
species coding given in the object's attribute \code{species_coding}. The
default is to request the choice with \code{options("fe_spec_lang")}. If
this option is not set, the choice "code" is used.}

\item{maxsum}{Same as parameter \code{maxsum} in \code{\link{summary.factor}}}

\item{...}{Other parameters (not used)}
}
\value{
A named vector in the same style as returned by
\code{\link{summary.factor}}
}
\description{
Produces a summary for a fe_species_ger_nfi_2012 object in the same style as
R does for factors. Actually, after some conversions
\code{\link{summary.factor}} \emph{is} called by this function. The species naming
in the summary depends on the parameter \code{spec_lang}.
}
\examples{
# Construct some species id vector
spec_ids <- c(
  rep(fe_species_ger_nfi_2012(c("170", "140", "120", "150")),
    times = c(151, 231, 70, 122)
  ),
  NA, NA, NA, NA
)

summary(spec_ids)
spec_ids |> summary()
spec_ids |> summary(spec_lang = "eng")

# Usual application: Set option for species code output
# Any summary of an fe_species object will use the last setting of the
# option
options(fe_spec_lang = "sci")
spec_ids |> summary()

}
