% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{evaluate_single_las}
\alias{evaluate_single_las}
\title{Evaluate predictions stored in a single LAS/LAZ}
\usage{
evaluate_single_las(
  las,
  truth_col = "label",
  pred_col = "Classification",
  classes = NULL,
  drop_na = TRUE,
  class_names = NULL,
  show_codes = TRUE
)
}
\arguments{
\item{las}{A \code{lidR::LAS} object containing truth and prediction fields.}

\item{truth_col}{Character. Name of the ground-truth label column (default \code{"label"}).}

\item{pred_col}{Character. Name of the prediction column (default \code{"Classification"}).}

\item{classes}{Optional integer vector of expected class IDs (e.g. \code{0:2}, \code{0:3}).
If \code{NULL}, inferred from observed truth and pred values.}

\item{drop_na}{Logical. If \code{TRUE} (default), rows with NA/Inf in truth or pred are dropped.}

\item{class_names}{Optional class name mapping. Either:
\itemize{
\item Named: \code{c("0"="Ground","1"="Branch","2"="Leaves")}
\item Unnamed length-K: \code{c("Ground","Branch","Leaves")} (must match \code{classes})
}}

\item{show_codes}{Logical. If \code{TRUE} (default), class labels display like \code{"0 (Ground)"}.}
}
\value{
A list containing the confusion matrix and metrics.
}
\description{
Computes a confusion matrix and standard multi-class metrics when both the
ground-truth labels and predictions are stored as columns in the same
\code{lidR::LAS} object.
}
\details{
The function returns:
\itemize{
\item \strong{overall_accuracy}: \eqn{\sum diag(cm) / \sum cm}
\item \strong{class_accuracy}: per-class accuracy computed as \eqn{TP / (TP+FN)}
(same as per-class recall / producer's accuracy).
\item \strong{precision}, \strong{recall}, \strong{f1}: per-class metrics.
\item \strong{balanced_accuracy}: mean of \code{class_accuracy} across classes (macro average).
}

To keep the confusion matrix shape stable across files (even when some classes
are missing), pass \code{classes = 0:2} or \code{classes = 0:3}.
}
\examples{
if (requireNamespace("lidR", quietly = TRUE)){

library(lidR)
las <-  readLAS(system.file("extdata", "las", "tree2.laz", package = "FuelDeep3D"))

res <- evaluate_single_las(
  las,
  truth_col = "label",
  pred_col  = "Classification",
  classes   = 0:2,
  class_names = c("0"="Ground","1"="Branch","2"="Leaves")
)

res$class_accuracy
cat(sprintf("accuracy = \%.2f\%\%\n", 100 * res$accuracy))
}
}
