% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py_deps.R
\name{install_py_deps}
\alias{install_py_deps}
\title{Install Python dependencies into a Conda environment (FuelDeep3D)}
\usage{
install_py_deps(
  envname = "pointnext",
  only_if_missing = TRUE,
  cpu_only = TRUE,
  conda = NULL
)
}
\arguments{
\item{envname}{Character. Name of the Conda environment.}

\item{only_if_missing}{Logical. Skip install if key modules are already present.}

\item{cpu_only}{Logical. If TRUE, installs CPU-only PyTorch; otherwise installs cu121 wheels.}

\item{conda}{Path to conda binary. Default uses \code{reticulate::conda_binary()}.}
}
\value{
Invisibly TRUE if installation ran, FALSE if skipped.
}
\description{
Installs required Python packages into an existing Conda environment using pip.
}
\details{
If \code{only_if_missing = TRUE}, checks for key importable modules and skips
installation when they already exist.
}
\examples{
\dontrun{
install_py_deps(envname = "pointnext", cpu_only = TRUE)
}

}
