% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\title{Simulate GARCHX model}
\usage{
simulate(n, omega, alpha, beta, delta = 2, X, pi, shock.distr = "Normal", valinit = 200)
}
\arguments{
\item{n}{Desired length of simulated time series data}

\item{omega}{Coefficient value for omega, required to be \deqn{\omega_0 > 0}}

\item{alpha}{ARCH Coefficient value, required to be \deqn{\alpha_0 \geq 0}}

\item{beta}{GARCH Coefficient value, required to be \deqn{\beta_0 \geq 0}}

\item{delta}{Value of the power of the time series to allow for Power GARCHX, default is 2 for GARCHX}

\item{X}{Matrix with exogenous covariates where the number of rows is equal to the length of n + valinit}

\item{pi}{Vector containing coefficients for exogenous covariates.}

\item{shock.distr}{Distribution of the shock eta_t that multiply w_t in the GARCH-X model eps_ = w_t*eta_t.}

\item{valinit}{Initialization value, default value is 200}
}
\value{
A named list containing vector of Time Series data and X covariates used
}
\description{
Simulates Time series data from GARCH model with exogenous covariates
}
\examples{
n <- 200
d <- 4
valinit <- 100
n2 <- n + d + 1
omega <- 0.05
alpha <- 0.05
beta <- 0.05
delta <- 2
pi <- rep(0.05, d)
e<-rnorm(n2+valinit)
Y<-e
for (t in 2:n2)
 Y[t]<- 0.2*Y[t-1]+e[t]
x<-exp(Y)
X <- matrix(0, nrow = (n+valinit), ncol = length(pi))
for(j in 1:d)
 X[, j] <- x[(d+2-j):(n+d+1-j+valinit)]
data <- simulate(n, omega, alpha, beta, delta, X, pi, valinit = valinit)
}
