% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnifiedEst.R
\name{UnifiedEst}
\alias{UnifiedEst}
\title{Unified GARCH-Ito Models}
\usage{
UnifiedEst(RV = RV, return = return)
}
\arguments{
\item{RV}{Time series of daily realized volatilities.}

\item{return}{Time series of daily log returns.}
}
\value{
Estimated parameter values and daily conditional volatilities:
\describe{
\item{coefficients}{parameter estimates of the realized GARCH-Ito model}
\item{sigma}{daily conditional volatility estimates of the realized GARCH-Ito model}
\item{pred}{one-step-ahead predicted volatility value}
}
}
\description{
Estimate model parameters for the Unified GARCH-Ito Model.
}
\examples{
sample_data
UnifiedEst(sample_data$RV, sample_data$return)
}
\references{
Kim, D. & Wang, Y. (2016). Unified discrete-time and continuous-time models and statistical
inferences for merged low-frequency and high-frequency financial data. Journal of Econometrics. 194:220-230.
}
