% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{model.matrix.lmgce}
\alias{model.matrix.lmgce}
\title{Extract design matrix from \code{\link{lmgce}} object}
\usage{
\method{model.matrix}{lmgce}(object, ...)
}
\arguments{
\item{object}{fitted \code{\link{lmgce}} object.}

\item{...}{additional arguments.}
}
\value{
A numeric matrix with one row for each observation and one column for
 each parameter in the model.
}
\description{
Returns the design matrix used to fit \code{\link{lmgce}} object.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        x = TRUE,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)

model.matrix(res_gce_package)
}

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
