% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averaged_trials.R
\name{averaged_trials}
\alias{averaged_trials}
\title{Averages signals across trials}
\usage{
averaged_trials(Dataframe, Trials)
}
\arguments{
\item{Dataframe}{a GCalcium-format data frame or matrix}

\item{Trials}{numbers of trials to be averaged across}
}
\value{
a data frame with observation times and averaged values
}
\description{
`averaged_trials` averages values over each time point, across the specified trials
}
\examples{
### Format data frame
df.new <- format_data(GCaMP)

### Plot the average fluorescence signal across trials 1-5
df.1thru5 <- averaged_trials(df.new, 1:5)

plot(x = df.1thru5$Time, df.1thru5$Values)
}
