% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPI_detect.R
\name{detect_nonmovement}
\alias{detect_nonmovement}
\title{Detect Non-movement}
\usage{
detect_nonmovement(
  binfile,
  binfile_path,
  output_folder,
  still_seconds = 120,
  sd_threshold = 0.013,
  temp_seconds = 240,
  border_seconds = 300,
  long_still_seconds = 120 * 60,
  delta_temp_threshold = -0.7,
  posture_changes_max = 2,
  non_move_duration_max = 12 * 60 * 60
)
}
\arguments{
\item{binfile}{Text lines read from an open connection to a bin file.}

\item{binfile_path}{Path to the bin file to be processed.}

\item{output_folder}{Path to the folder containing GENEAcore run outputs and Measurement Period Information (MPI) files.}

\item{still_seconds}{The number of seconds included in the rolling standard
deviation calculation for stillness to determine the shortest detection duration.}

\item{sd_threshold}{The threshold applied to the rolling standard deviation
of combined acceleration to determine stillness.}

\item{temp_seconds}{The number of seconds included in the rolling temperature
difference calculation or non-wear which also determines the shortest detection duration.}

\item{border_seconds}{The minimum number of seconds of a still event to be classed as a new bout.}

\item{long_still_seconds}{The minimum number of seconds of a still bout that is classed as non-wear.}

\item{delta_temp_threshold}{The threshold applied to the rolling temperature difference to determine non-wear.}

\item{posture_changes_max}{The maximum number of adjoining events that make up a single bout.}

\item{non_move_duration_max}{The maximum number of seconds of a still bout to be classed as non-movement.
Still bouts with a duration longer than this number is automatically classed as non-wear.}
}
\value{
List of sphere points, non-movement bouts and non-wear events.
}
\description{
Detect Non-movement
}
\details{
Function to detect non-movement bouts, non-wear events and points in a 1Hz
downsampled bin file.
}
\examples{
binfile_path <- system.file("extdata/20Hz_file.bin", package = "GENEAcore")
con <- file(binfile_path, "r")
binfile <- readLines(con, skipNul = TRUE)
close(con)
output_folder <- tempdir()
MPI <- create_MPI(binfile, binfile_path, output_folder)
MPI <- detect_nonmovement(binfile, binfile_path, output_folder)
}
