% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphfanova.r
\name{frank.fanova}
\alias{frank.fanova}
\title{Rank envelope F-test}
\usage{
frank.fanova(
  nsim,
  curve_set,
  groups,
  variances = "equal",
  test.equality = c("mean", "var", "cov"),
  cov.lag = 1,
  savefuns = FALSE,
  ...
)
}
\arguments{
\item{nsim}{The number of random permutations.}

\item{curve_set}{The original data (an array of functions) provided as a
\code{\link{curve_set}} object or a \code{fdata} object of \pkg{fda.usc}.
The curve set should include the argument values for the functions in the component \code{r}, and
the observed functions in the component \code{obs}.}

\item{groups}{The original groups (a factor vector representing the assignment to groups).}

\item{variances}{Either "equal" or "unequal". If "equal", then the traditional F-values are used.
If "unequal", then the corrected F-values are used. The current implementation uses
\code{\link[stats]{lm}} to get the corrected F-values.}

\item{test.equality}{A character with possible values \code{mean} (default), \code{var} and
\code{cov}. If \code{mean}, the functional ANOVA is performed to compare the means in the groups.
If \code{var}, then the equality of variances of the curves in the groups is tested by performing
the graphical functional ANOVA test on the functions
\deqn{Z_{ij}(r) = T_{ij}(r) - \bar{T}_j(r).}{Z_{ij}(r) = T_{ij}(r) - \bar{T}_j(r).}
If \code{cov}, then the equality of lag \code{cov.lag} covariance is tested by performing the fANOVA with
\deqn{W_{ij}(r) = \sqrt{|V_{ij}(r)|\cdot sign(V_{ij}(r))},}{|V_{ij}(r)| sign(V_{ij}(r)),}
where
\deqn{V_{ij}(r) = (T_{ij}(r) - \bar{T}_j(r))((T_{ij}(r+s) - \bar{T}_j(r+s))).}{V_{ij}(r) = (T_{ij}(r) - \bar{T}_j(r))((T_{ij}(r+s) - \bar{T}_j(r+s))).}
See Mrkvicka et al. (2020) for more details.}

\item{cov.lag}{The lag of the covariance for testing the equality of covariances,
see \code{test.equality}.}

\item{savefuns}{Logical. If TRUE, then the functions from permutations are saved to the attribute
simfuns.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}}.
For example, the type of multiple testing control, FWER or FDR must be set by \code{typeone}.
And, if \code{typeone = "fwer"}, the type of the global envelope can be chosen by
specifying the argument \code{type}. See \code{\link{global_envelope_test}}
for the defaults and available options.
(The test here uses \code{alternative="two.sided"} and \code{nstep=1} (when relevant),
but all the other specifications are to be given in \code{...}.)}
}
\description{
A one-way functional ANOVA based on the rank envelope applied to F values
}
\details{
The test assumes that there are \eqn{J}{J} groups which contain
\eqn{n_1,\dots,n_J}{n1, ..., nJ} functions
\eqn{T_{ij}, i=\dots,J, j=1,\dots,n_j}{T_{ij}, i=1,...,J, j=1,...,nj}.
The functions should be given in the argument x, and the groups in the argument groups.
The test assumes that there exists non random functions \eqn{\mu(r)}{\mu(r)} and
\eqn{\mu_i(r)}{\mu_i(r)} such that
\deqn{T_{ij}(r) =\mu(r) + \mu_i(r) + e_{ij}(r), i=1, \dots, J, j=1, \dots , n_j}{T_{ij}(r) =\mu(r) + \mu_i(r) + e_{ij}(r), i=1, ..., J, j=1, ..., nj}
where \eqn{e_{ij}(r)}{e_{ij}(r)} are independent and normally distributed.
The test vector is
\deqn{\mathbf{T} = (F(r_1), F(r_2), \dots , F(r_K)),}{T = (F(r_1), F(r_2), \dots , F(r_K)),}
where \eqn{F(r_i)}{F(r_i)} stands for the F-statistic. The simulations are performed by
permuting the test functions. Further details can be found in Mrkvička et al. (2020).

The argument \code{variances="equal"} means that equal variances across groups are assumed.
The correction for unequal variances can be done by using the corrected F-statistic
(option \code{variances="unequal"}).

Unfortunately this test is not able to detect which groups are different from each other.
}
\examples{
data("rimov")
groups <- factor(c(rep(1, times=12), rep(2, times=12), rep(3, times=12)))
\donttest{res <- frank.fanova(nsim = 2499, curve_set = rimov, groups = groups)}
\dontshow{res <- frank.fanova(nsim = 4, curve_set = rimov, groups = groups, alpha = 0.2)}
plot(res)

data("imageset3")
res2 <- frank.fanova(nsim = 19, # Increase nsim for serious analysis!
                     curve_set = imageset3$image_set,
                     groups = imageset3$Group)
plot(res2)
plot(res2, fixedscales=FALSE)
}
\references{
Mrkvička, T., Myllymäki, M., Jilek, M. and Hahn, U. (2020) A one-way ANOVA test for functional data with graphical interpretation. Kybernetika 56 (3), 432-458. doi: 10.14736/kyb-2020-3-0432
}
\seealso{
graph.fanova
}
