% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GETD.R
\name{GETD}
\alias{GETD}
\title{Generalized Extended Triangular Designs}
\usage{
GETD(n, m, trt = 1)
}
\arguments{
\item{n}{It is a natural number such that n >= 2m ; m >= 2}

\item{m}{It is a natural number such that m >= 2}

\item{trt}{Provide any treatment number to know its all associates. By default it is 1.}
}
\value{
This package generates an m-associate (m >= 2) class PBIB designs under GET Association Scheme. It also calculates the Information matrix, Average variance factor, canonical efficiency factor and different treatment associates of the generated designs.
}
\description{
This package contains a function named GETD() for generating m-associate (m>=2) class PBIB designs along with parameters (v, b, r, k and lambda_i, i = 1, 2,…,m) and the underlying Generalized Extended Triangular (GET) Association Scheme.
}
\examples{
library(GETdesigns)
GETD(6,2,1)
}
\references{
1) R.C. Bose, K.R. Nair (1939)< https://www.jstor.org/stable/40383923>" Partially balanced incomplete block designs ".

2) R.C. Bose, T. Shimamoto (1952)<doi:10.1080/01621459.1952.10501161> "Classification and analysis of partially balanced incomplete block designs with two associate classes".
}
