\name{hiv}
\alias{hiv}
\alias{hiv.polys}
\docType{data}


\title{HIV Zambian data}

\description{HIV Zambian data by region, together with polygons describing the regions' shapes.}

\usage{
data(hiv)
data(hiv.polys)
}



\format{ \code{hiv} is a 6416 row data frame with the following columns: 



\describe{


\item{consent}{binary variable indicating consent to test for HIV.}
\item{status}{binary variable indicating whether an individual is HIV positive (status = 1) or not (status = 0).}
\item{age}{age in years.}
\item{education}{years of education.}
\item{wealth}{wealth index.}
\item{region}{code identifying region, and matching \code{names(hiv.polys)}. It can take nine possible values: 1 central, 2 copperbelt, 3 eastern, 
             4 luapula, 5 lusaka, 6 northwestern, 7 northern, 8 southern, 9 western.}
\item{marital}{never married, currently married, formerly married.}
\item{std}{had a sexually transmitted disease.}
\item{highhiv}{had high risk sex.}
\item{partner}{number of partners.}
\item{condom}{used condom during last intercourse.}
\item{aidscare}{equal to 1 if would care for an HIV-infected relative.}
\item{knowsdiedofaids}{equal to 1 if know someone who died of HIV.}
\item{evertestedHIV}{equal to 1 if previously tested for HIV.}           
\item{smoke}{smoker or not.}         
\item{ethnicity}{bemba, lunda (luapula), lala, ushi, lamba, tonga, luvale,
lunda (northwestern), mbunda, kaonde, lozi, chewa, nsenga,
ngoni, mambwe, namwanga, tumbuka, other.}              
\item{language}{English, Bemba, Lozi, Nyanja, Tonga, other.}                     
\item{interviewerID}{interviewer identifier.}  
\item{agehadsex}{age the individual had sex.}
\item{religion}{four categories.}
\item{sw}{survey weights.} 


}



\code{hiv.polys} contains the polygons defining the areas in the format described below.
} 


\details{The data frame \code{hiv} relates to the regions whose boundaries are coded in \code{hiv.polys}.
\code{hiv.polys[[i]]} is a 2 column matrix, containing the vertices of the polygons defining the boundary of the ith 
region. \code{names(hiv.polys)} matches \code{hiv$region} (order unimportant).

}

\source{

The data have been produced as described in: 

McGovern M.E., Barnighausen T., Marra G. and Radice R. (2015), On the Assumption of Joint Normality in Selection Models: A Copula Approach Applied to Estimating HIV Prevalence. \emph{Epidemiology}, 26(2), 229-237.


}


\references{

Marra G., Radice R., Barnighausen T., Wood S.N. and McGovern M.E. (2017), A Simultaneous Equation Approach to Estimating HIV Prevalence with Non-Ignorable Missing Responses. \emph{Journal of the American Statistical Association}, 112(518), 484-496.


}




