% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{gev.xifix.sing}
\alias{gev.xifix.sing}
\title{MLE for GEV with fixed shape parameter (single candidate)}
\usage{
gev.xifix.sing(xdat = NULL, xifix = -0.1, ntry = 5, varcom = NULL)
}
\arguments{
\item{xdat}{Numeric vector of data.}

\item{xifix}{Fixed shape parameter value. Default is -0.1.}

\item{ntry}{Number of optimization attempts. Default is 5.}

\item{varcom}{Logical. If TRUE, computes Prescott-Walden covariance matrix.}
}
\value{
A list of class "gev.xifix" containing:
\describe{
  \item{conv}{Convergence status (0 = success)}
  \item{nllh}{Negative log-likelihood at the optimum}
  \item{mle}{MLE estimates (mu, sigma, xi)}
  \item{cov}{2x2 covariance matrix (if \code{varcom=TRUE})}
}
}
\description{
Internal function that computes MLE of GEV location and scale
parameters with a fixed shape parameter using L-BFGS-B optimization.
Optionally computes Prescott-Walden Hessian for variance estimation.
}
\keyword{internal}
