% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_plots.R
\name{magev.qqplot}
\alias{magev.qqplot}
\title{Q-Q Diagnostic Plot for MAGEV}
\usage{
magev.qqplot(data = NULL, zx = NULL)
}
\arguments{
\item{data}{A numeric vector of observed data.}

\item{zx}{A list object returned by \code{\link{ma.gev}} with \code{remle = TRUE}.}
}
\value{
NULL. The function produces a plot as a side effect.
}
\description{
Creates a 2x2 panel of Q-Q plots comparing observed vs. fitted quantiles
for different estimation methods: MLE, LME, surrogate (MA), and REMLE.
}
\details{
The function creates four Q-Q plots:
\itemize{
  \item Upper left: MLE (Maximum Likelihood Estimation)
  \item Upper right: LME (L-moment Estimation)
  \item Lower left: Surrogate MA (Model Averaging surrogate)
  \item Lower right: REMLE (Restricted MLE, if available)
}

Points close to the 45-degree diagonal line indicate good model fit.
}
\examples{
data(streamflow)
qq <- c(seq(0.01, 0.99, by = 0.01), 0.995, 0.999)
zx <- ma.gev(streamflow$r1, quant = qq, weight = 'like1',
             numk = 9, varcom = FALSE, remle = TRUE)
magev.qqplot(data = streamflow$r1, zx = zx)

}
\references{
Shin, Y., Shin, Y., & Park, J. S. (2026). Model averaging with mixed criteria
for estimating high quantiles of extreme values: Application to heavy rainfall.
\emph{Stochastic Environmental Research and Risk Assessment}, 40(2), 47.
\doi{10.1007/s00477-025-03167-x}
}
\seealso{
\code{\link{ma.gev}} for the main model averaging function,
  \code{\link{magev.rlplot}} for return level plots.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
