% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{remle.gev}
\alias{remle.gev}
\title{Restricted MLE for GEV (Mixed Estimation)}
\usage{
remle.gev(
  xdat,
  ntry = 5,
  rest = "mean",
  quant = c(0.99, 0.995),
  trim = 0,
  CD.mle = NULL,
  mle = NULL,
  second = TRUE,
  w.mpse = FALSE
)
}
\arguments{
\item{xdat}{Numeric vector of data.}

\item{ntry}{Number of random starting points. Default is 5.}

\item{rest}{Restriction type: 'mean' (default) or 'median'.}

\item{quant}{Probabilities for quantile estimation. Default is c(0.99, 0.995).}

\item{trim}{Left trimming level. Default is 0.}

\item{CD.mle}{Coles-Dixon MLE (optional). If NULL, computed internally.}

\item{mle}{Standard MLE (optional). If NULL, computed internally.}

\item{second}{Logical. If TRUE, compute second-stage REMLE. Default is TRUE.}

\item{w.mpse}{Logical. If TRUE, compute MPSE. Default is FALSE.}
}
\value{
A list containing:
  \item{remle1}{First-stage REMLE estimates}
  \item{qua.remle1}{Quantiles from first-stage REMLE}
  \item{remle2}{Second-stage REMLE estimates (if second=TRUE)}
  \item{qua.remle2}{Quantiles from second-stage REMLE}
  \item{rest.method}{Restriction method used}
}
\description{
Computes restricted maximum likelihood estimates for GEV parameters
with constraints on the mean or median matching the sample statistics.
}
\keyword{internal}
