% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev11.R
\name{wls.gev11}
\alias{wls.gev11}
\title{Weighted least squares core estimation for GEV11}
\usage{
wls.gev11(xdat, res = NULL, rob = NULL)
}
\arguments{
\item{xdat}{Numeric vector of data.}

\item{res}{Numeric vector of residuals from initial location regression.}

\item{rob}{Logical. If TRUE, use robust regression. If FALSE, use OLS.}
}
\value{
A list containing:
\describe{
  \item{sig}{Log-scale regression coefficients c(sigma0, sigma1)}
  \item{m}{Location regression coefficients c(mu0, mu1)}
  \item{res}{Standardized residuals}
}
}
\description{
Internal function that performs the core WLS steps:
(Step 3) estimate log-scale trend from absolute residuals,
(Step 4) estimate location trend from weighted data,
(Step 5) compute standardized residuals.
}
\keyword{internal}
