\name{getInit}
\alias{getInit}
\title{Initialize Parameters for the EM Algorithm in Gaussian Mixture Models}
\description{
Selects an initialization method to generate starting parameters 
for the Expectation-Maximization (EM) algorithm in Gaussian Mixture Models (GMMs).
}
\usage{
getInit(x, k, method, run_number = 10, max_iter = 3, tol = 1e-6, burn_in = 3)
}
\arguments{
  \item{x}{A numeric matrix or data frame where rows represent observations and columns represent variables.}
  \item{k}{An integer specifying the number of clusters.}
  \item{method}{A character string specifying the initialization method to use. Options include:
    \itemize{
      \item \code{"Random"}: Randomly generates cluster centers.
      \item \code{"emEM"}: Multi-start EM initialization and choose the one with maximum loglikelihood.
      \item \code{"emAEM"}: Alternative Expectation-Maximization initialization.
      \item \code{"hierarchical average"}: Uses hierarchical clustering (average linkage).
      \item \code{"hierarchical ward"}: Uses hierarchical clustering (Ward’s method).
      \item \code{"kmeans"}: Uses k-means clustering to initialize parameters.
      \item \code{"mclust"}: Uses model-based clustering from the \pkg{mclust} package.
      \item \code{"cem"}: Classification Expectation-Maximization (CEM).
      \item \code{"sem"}: Stochastic Expectation-Maximization (SEM).
    }
  }
  \item{run_number}{An integer specifying the number of times the initialization process should be repeated for emEM and emAEM (default is 10).}
  \item{max_iter}{An integer specifying the maximum number of iterations for emEM and emAEM  initialization (default is 3).}
  \item{tol}{A numeric value specifying the convergence tolerance for the EM algorithm (default is \code{1e-6}).}
  \item{burn_in}{An integer specifying the number of burn-in iterations for stochastic methods (default is 3).}
}
\value{
A list containing the initialized parameters for the EM algorithm, including:
  \itemize{
    \item \code{mu}: Cluster means.
    \item \code{sigma}: Covariance matrices.
    \item \code{pi}: Mixing proportions.
  }
}
\details{
This function selects an appropriate initialization method and returns the starting values for the EM algorithm.
It helps to prevent local optima issues and improve convergence in Gaussian mixture models.
}
\seealso{
\code{\link[mclust]{mclust}}, \code{\link[stats]{kmeans}}
}
\examples{
# Generate sample data
set.seed(123)
data <- matrix(rnorm(100 * 2), ncol = 2)

# Compute optimal initialization using k-means
library(GMMinit)
init_params <- getInit(data, k = 2, method = "kmeans")
print(init_params)
}
\keyword{clustering}
\keyword{EM}
\keyword{mixture model}
