% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPdistance.R
\name{DPdistance}
\alias{DPdistance}
\title{calculate degree profile distances between 2 graphs.}
\usage{
DPdistance(A, B, fun = NULL)
}
\arguments{
\item{A, B}{Two 0/1 adjacency matrices.}

\item{fun}{Optional function that computes distance between two distributions.}
}
\value{
A distance matrix. Rows represent nodes in graph \emph{A} and columns
  represent nodes in graph \emph{B}. Its \emph{(i, j)} element is the
  distance between \eqn{i \in A} and \eqn{i \in B}.
}
\description{
This function constructs empirical distributions of degree profiles for each
vertex and then calculate distances between each pair of vertices, one from
graph \emph{A} and the other from graph \emph{B}. The default distance used is the
1-Wasserstein distance.
}
\examples{
set.seed(2020)
n = 10; q = 1/2; s = 1; p = 1
Parent = matrix(rbinom(n*n, 1, q), nrow = n, ncol = n)
Parent[lower.tri(Parent)] = t(Parent)[lower.tri(Parent)]
diag(Parent) <- 0
### Generate graph A
dA = matrix(rbinom(n*n, 1, s), nrow = n, ncol=n);
dA[lower.tri(dA)] = t(dA)[lower.tri(dA)]
A1 = Parent*dA
tmp = rbinom(n, 1, p)
n.A = length(which(tmp == 1))
indA = sample(1:n, n.A, replace = FALSE)
A = A1[indA, indA]
### Generate graph B
dB = matrix(rbinom(n*n, 1, s), nrow = n, ncol=n);
dB[lower.tri(dB)] = t(dB)[lower.tri(dB)]
B1 = Parent*dB
tmp = rbinom(n, 1, p)
n.B = length(which(tmp == 1))
indB = sample(1:n, n.B, replace = FALSE)
B = B1[indB, indB]
DPdistance(A, B)
}
