% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_distribution.R
\name{flex_distribution}
\alias{flex_distribution}
\title{flex_distribution function}
\usage{
flex_distribution(
  distribution_data,
  interactive = TRUE,
  user_colors = NULL,
  plot_type = "histogram",
  add_density = FALSE,
  reference_line = "mean",
  show_summary = FALSE,
  user_title = "Distribution Plot",
  user_x_title = NULL,
  user_y_title = "Frequency",
  user_legend_title = NA,
  user_plot_theme = theme_minimal(),
  user_plot_theme_specs = theme(legend.title = element_blank(), legend.text =
    element_text(size = 10), title = element_text(size = 15), axis.text.x =
    element_text(size = 10), axis.title.x = element_text(size = 10), axis.text.y =
    element_text(size = 10), axis.title.y = element_text(size = 10)),
  binwidth = NULL,
  bins = NULL
)
}
\arguments{
\item{distribution_data}{A dataframe where each column represents a data
distribution (e.g. population) to be plotted with minimum of a single column.}

\item{interactive}{Logical, if TRUE (default), the plot will be interactive
using Plotly, otherwise a ggplot object is returned.}

\item{user_colors}{A vector of colors for the plots. If NULL, a set of default
colors is used.}

\item{plot_type}{The type of plot to create, with options "histogram" and/or
"density".}

\item{add_density}{Logical, if TRUE, adds a density curve to the plot.}

\item{reference_line}{Specifies the type of reference line to add; options
include "mean", "median", or FALSE for no line.}

\item{show_summary}{Logical, if TRUE, displays summary statistics on the plot.}

\item{user_title}{Title of the plot.}

\item{user_x_title}{Custom X-axis title. If NULL, the name of the variable is
used.}

\item{user_y_title}{Custom Y-axis title, default is "Frequency".}

\item{user_legend_title}{Title for the legend. Can be NA to exclude the legend title.}

\item{user_plot_theme}{ggplot2 theme object for customizing the appearance of the plot.}

\item{user_plot_theme_specs}{Further ggplot2 theme specifications.}

\item{binwidth}{The width of the bins for the histogram (optional).}

\item{bins}{The number of bins for the histogram (optional).}
}
\value{
An object of class 'ggplot' or 'plotly' depending on the 'interactive' parameter.
}
\description{
The \code{flex_distribution} function provides a flexible way to visualize data
distributions using histograms and density plots. It can be used to create
both basic and interactive plots with additional features such as density
curves, reference lines, and summary statistics annotations. The function
supports custom colors and various themes.
}
\details{
The function is designed to be flexible and allows extensive customization
of plot aesthetics and functionality. Density plots are added as an additional
layer when \code{add_density} is TRUE, and the reference line can be specified by the user.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
# Histogram with custom colors
custom_colors <- c("red", "blue", "green")
flex_distribution(example_data8, user_colors = custom_colors)

# Density plot
flex_distribution(
  example_data8, 
  plot_type = "density", 
  user_colors = custom_colors,
  user_y_title = "Density"
)

#' # Basic histogram with density curves and summary statistics
flex_distribution(
  example_data8, 
  add_density = TRUE, 
  show_summary = TRUE,
  user_title = "Distribution with Densities and Summary",
  user_y_title = "Density"
)

# Histogram with custom binwidth
flex_distribution(
  example_data8, 
  binwidth = 0.5,
  user_title = "Distribution with Custom Binwidth"
)

# Histogram with a specified number of bins
flex_distribution(
  example_data8, 
  bins = 50,
  user_title = "Distribution with Custom Bin Count"
)

}
