% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRCdesigns.R
\name{SCGRC_III}
\alias{SCGRC_III}
\title{Structurally Complete Generalized Row Column Designs of Series-III}
\usage{
SCGRC_III(v, k)
}
\arguments{
\item{v}{Prime number(>3)}

\item{k}{Number of units per cell}
}
\value{
This function generates structurally complete GRC designs for prime number of treatment as well as the information matrix for estimating elementary treatment contrast.
}
\description{
The resulting design is a GRC designs with v (prime number) treatments in p = 2 rows, q = v(v-1) /2 columns and each cell of size k (2 <= k <= v-1).
}
\examples{
library(GRCdesigns)
SCGRC_III(7,2)
}
\references{
1) Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2014). Structurally incomplete row-column designs with multiple units per cell. Statistics and Applications, 12(1&2), 71-79.

2)Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2015). Some series of row-column designs with multiple units per cell. Calcutta Statistical Association Bulletin, 67, ( 265-266), 89-99.

3)Datta, A., Jaggi, S., Varghese, C. and Varghese, E.  (2016). Series of incomplete row-column designs with two units per cell. Advances in Methodology and Statistics. 13(1), 17-25.
}
