% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filteringPaths.R
\name{filteringPaths}
\alias{filteringPaths}
\title{Fuction for filtering gene sets with low expression}
\usage{
filteringPaths(objectMApath, threshold = 0.65, n_cores = 1)
}
\arguments{
\item{objectMApath}{A list of list. Each list contains two elements.
The first element is the Gene Set matrix (gene sets in rows and samples in
columns) and the second element is a vector of zeros and ones that represents
the state of the different samples of the Gene Sets matrix.
0 represents one group (controls) and 1 represents the other group (cases).}

\item{threshold}{A number that indicates the threshold to eliminate a gene
set. For a eliminate a gene set is necessary that the median for both groups
are less than the threshold
If  threshold = "sd" the threshold will be the standard deviation of the
gene set. The default value is 0.65.}

\item{n_cores}{A number that indicates the number of cores to use in the
parallelization. The default value is 1.}
}
\value{
The same objectMApath list but with the gene sets that do not meet
the threshold eliminated.
}
\description{
This function eliminates gene sets with low expression in both groups in
a study
}
\examples{

data("simulatedData")
newObject <- filteringPaths(objectMApathSim, threshold = "sd")

}
\seealso{
\code{\link{createObjectMApath}}
}
\author{
Juan Antonio Villatoro Garcia,
\email{juanantoniovillatorogarcia@gmail.com}
}
