% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSSTDA_objects.R
\name{gene_selection.dsga_object}
\alias{gene_selection.dsga_object}
\title{gene_selection_classes.dsga_object}
\usage{
\method{gene_selection}{dsga_object}(data_object, gen_select_type, percent_gen_select, na.rm = TRUE)
}
\arguments{
\item{data_object}{dsga object information}

\item{gen_select_type}{Option. Options on how to select the genes to be
used in the mapper. Select the "Abs" option, which means that the
genes with the highest absolute value are chosen, or the
"Top_Bot" option, which means that half of the selected
genes are those with the highest value (positive value, i.e.
worst survival prognosis) and the other half are those with the
lowest value (negative value, i.e. best prognosis). "Top_Bot" default option.}

\item{percent_gen_select}{Percentage (from zero to one hundred) of genes
to be selected to be used in mapper. 10 default option.}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.
If \code{FALSE}, an error occurs in case of \code{NA} rows. TRUE default
option.}
}
\value{
A \code{gene_selection} object. It contains: the full_data without NAN's values,
the control tag of the healthy patient, the matrix with the normal space and
the matrix of the disease components.
}
\description{
Private function to select Gene with dsga object
}
\examples{
\donttest{
dsga_obj <- dsga(full_data, survival_time, survival_event, case_tag, na.rm = "checked")

gene_selection_object <- gene_selection(dsga_obj, gen_select_type ="top_bot",
                                      percent_gen_select = 10)}
}
