% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fGTDL.R
\name{fGTDL}
\alias{fGTDL}
\alias{dGTDL}
\alias{hGTDL}
\alias{sGTDL}
\alias{rGTDL}
\alias{fires}
\title{The GTDL distribution}
\source{
[d-p-q-r]GTDL are calculated directly from the definitions.
}
\usage{
dGTDL(t, param, log = FALSE)

hGTDL(t, param)

sGTDL(t, param)

rGTDL(n, param)
}
\arguments{
\item{t}{vector of integer positive quantile.}

\item{param}{parameters (alpha and gamma are scalars, lambda non-negative).}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations.}
}
\value{
\code{dGTDL} gives the density function, \code{hGTDL} gives the failure function, \code{sGTDL} gives the survival function and \code{rGTDL} generates random samples.

Invalid arguments will return an error message.
}
\description{
Density function, survival function, failure function and random 
generation for the GTDL distribution.
}
\details{
\itemize{
\item Density function
\deqn{f(t\mid \boldsymbol{\theta})=\lambda\left(\frac{\exp\{\alpha{t}+\boldsymbol{X}^{\top}\boldsymbol{\beta}\}}{1+\exp\{\alpha{t}+\boldsymbol{X}^{\top}\boldsymbol{\beta}\}}\right)\times\left(\frac{1+\exp\{\alpha{t}+\boldsymbol{X}^{\top}\boldsymbol{\beta}\}}{1+\exp\{\boldsymbol{X}^{\top}\boldsymbol{\beta}\}}\right)^{-\lambda/\alpha}}

\item Survival function
\deqn{S(t \mid \boldsymbol{\theta})=\left(\frac{1+\exp\{\alpha{t}+\boldsymbol{X}^{\top}\boldsymbol{\beta}\}}{1+\exp\{\boldsymbol{X}^{\top}\boldsymbol{\beta}\}}\right)^{-\lambda/\alpha}}

\item Failure function
\deqn{h(t\mid\boldsymbol{\theta})=\lambda\left(\frac{\exp\{\alpha{t}+\boldsymbol{X}^{\top}\boldsymbol{\beta}\}}{1+\exp\{\alpha{t}+\boldsymbol{X}^{\top}\boldsymbol{\beta}\}}\right)}

}
}
\examples{

library(GTDL)
t <- seq(0,20,by = 0.1)
lambda <- 1.00
alpha <- -0.05
gamma <- -1.00
param <- c(lambda,alpha,gamma)
y1 <- hGTDL(t,param)
y2 <- sGTDL(t,param)
y3 <- dGTDL(t,param,log = FALSE)
tt <- as.matrix(cbind(t,t,t))
yy <- as.matrix(cbind(y1,y2,y3))
matplot(tt,yy,type="l",xlab="time",ylab="",lty = 1:3,col=1:3,lwd=2)


y1 <- hGTDL(t,c(1,0.5,-1.0))
y2 <- hGTDL(t,c(1,0.25,-1.0))
y3 <- hGTDL(t,c(1,-0.25,1.0))
y4 <- hGTDL(t,c(1,-0.50,1.0))
y5 <- hGTDL(t,c(1,-0.06,-1.6))
tt <- as.matrix(cbind(t,t,t,t,t))
yy <- as.matrix(cbind(y1,y2,y3,y4,y5))
matplot(tt,yy,type="l",xlab="time",ylab="Hazard function",lty = 1:3,col=1:3,lwd=2)



}
\references{
\itemize{
\item Mackenzie, G. (1996). Regression Models for Survival Data: The Generalized Time-Dependent Logistic Family. Journal of the Royal Statistical Society. 
Series D (The Statistician). 45. 21-34. 
}
}
