#' RCAG-DD Test
#'
#' Performs the RCAG-DD RIG-DD test of randomness for circular data.
#'
#' @param theta A numeric vector representing endpoints of arcs.
#' @return Vector of test statistics of RCAG-DD Test.
#' @examples
#' x <- arima.sim(model = list(ar=c(0.6,0.3)), 1000) ## AR(2) model
#' theta <- ((2*atan(x))%%(2*pi))*(180/pi) ##LAR(2) model
#' rcagdd.test(theta)
#' @export
rcagdd.test <- function(theta) {
  m = length(theta)
  nv = m %/% 2
  r = m %% 2
  cdf_t <- cdf.rcag(m)
  pdf_t <- c()
  pdf_t[1] = cdf_t[1]
  for (i in 2:nv) {
    pdf_t[i] <- cdf_t[i] - cdf_t[i - 1]
  }
  HD <- c()

  for (i in 1:(r + 1)) {
    theta_r <- theta[i:(2 * nv + i - 1)]
    deg <- deg.rcag(theta_r)
    pdf <- c()
    for (j in 1:nv) {
      pdf[j] <- sum(deg == j) / nv
    }
    HD[i] <- hellinger.dist(pdf, pdf_t)
  }
  structure(list(
    statistic = HD,
    method     = "RCAG-DD Test",
    data.name  = deparse(substitute(theta))
  ),
  class = "rcagdd")
}
