% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_delete_dataset}
\alias{galaxy_delete_dataset}
\title{Delete a Galaxy dataset by ID}
\usage{
galaxy_delete_dataset(
  dataset_id,
  purge = TRUE,
  verbose = FALSE,
  galaxy_url = "https://usegalaxy.eu"
)
}
\arguments{
\item{dataset_id}{Character. The Galaxy dataset ID to delete.}

\item{purge}{Logical. If \code{TRUE} the API call will include
\code{purge=true} to permanently remove the dataset and free
space. If \code{FALSE} the dataset may be only soft-deleted
depending on Galaxy configuration. Default: \code{TRUE}.}

\item{verbose}{Logical. If \code{TRUE} a message with the HTTP
status code will be printed. Default: \code{TRUE}.}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}
}
\value{
A named list with elements:
\describe{
\item{success}{Logical. \code{TRUE} for 2xx responses, otherwise \code{FALSE}.}
\item{status}{Integer. HTTP status code returned by the API.}
\item{content}{Character. The raw response body (text).}
}
}
\description{
Delete a dataset (HDA) from a Galaxy instance using the Galaxy API.
}
\details{
This function performs an HTTP DELETE against the Galaxy
/api/datasets/id endpoint. By default it requests a purge
(permanent removal) by adding ?purge=true. The Galaxy API key is
read from the environment variable \code{GALAXY_API_KEY}.
\itemize{
\item Make sure \code{Sys.getenv("GALAXY_API_KEY")} is set to a valid API key..
\item Use caution when running with \code{purge = TRUE} as this permanently
removes data.
}
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
input_file <- tempfile(fileext = ".txt")
test_text <- "This is an example \nfile."
writeLines(test_text,input_file)
history_id <- galaxy_initialize("test upload")
dataset_id <- galaxy_upload_https(input_file, history_id)

galaxy_delete_dataset(dataset_id)

\dontshow{\}) # examplesIf}
}
