#'@title Function to estimate quantiles for residuals of generalized Ornstein-Uhlenbeck (GOU) process
#'
#'@description Computation of quantiles for Cramer-von Mises and Kolmogorov-Smirnov statistics for testing goodness-of-fit of GOU
#'
#'@param n          number of points
#'@param B          number of bootstrap samples (default 50000)
#'@param alpha      vector of probabilities (default is (.90,.95,.975,.99))
#'@param n_cores    number of cores for parallel computing (default is 2)
#'
#'@return \item{q}{Data frame of simulated quantiles of weighted BM}
#'@export
#'
#' q100=SimQuantilesGoF(100,3, c(.90,.95,.975,.99),n_cores=2)



SimQuantilesGoF <- function(n, B=50000, alpha=c(.90,.95,.975,.99), n_cores=2)
  {

  cl <- parallel::makePSOCKcluster(n_cores)
  doParallel::registerDoParallel(cl)

  result <- foreach::foreach(i=1:B) %dopar% funGoF(n)
  parallel::stopCluster(cl)
  stat.ks  = rep(0,B)
  stat.cvm = rep(0,B)
  for (i in 1:B){
    stat.ks[i]  = result[[i]]$ks
    stat.cvm[i] = result[[i]]$cvm
  }
  q.ks  = quantile(stat.ks, alpha)
  q.cvm = quantile(stat.cvm, alpha)
  q = data.frame(ks=q.ks,cvm=q.cvm)
  return(q) # Critical value for the specified significance level
}
