% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoTox.R
\name{GeoTox}
\alias{GeoTox}
\alias{plot.GeoTox}
\title{GeoTox S3 object}
\usage{
GeoTox()

\method{plot}{GeoTox}(x, type = c("resp", "hill", "exposure", "sensitivity"), ...)
}
\arguments{
\item{x}{GeoTox object.}

\item{type}{type of plot.}

\item{...}{arguments passed to subsequent methods.}
}
\value{
a GeoTox S3 object
}
\description{
An S3 object that can be used to help organize the data and results of a
GeoTox analysis.
}
\examples{
# Use a subset of the package data for demonstration purposes
set.seed(2357)
n <- 10 # Population size
m <- 5 # Number of regions
idx <- if (m < 100) sample(1:100, m) else 1:100

geoTox <- GeoTox() |> 
  # Set region and group boundaries (for plotting)
  set_boundaries(region = geo_tox_data$boundaries$county,
                 group  = geo_tox_data$boundaries$state) |> 
  # Simulate populations for each region
  simulate_population(age           = split(geo_tox_data$age, ~FIPS)[idx],
                      obesity       = geo_tox_data$obesity[idx, ],
                      exposure      = split(geo_tox_data$exposure, ~FIPS)[idx],
                      simulated_css = geo_tox_data$simulated_css,
                      n             = n) |> 
  # Estimated Hill parameters
  set_hill_params(geo_tox_data$dose_response |>
                    fit_hill(assay = "endp", chem = "casn") |> 
                    dplyr::filter(!tp.sd.imputed, !logAC50.sd.imputed)) |>
  # Calculate response
  calculate_response() |>
  # Perform sensitivity analysis
  sensitivity_analysis()

# Print GeoTox object
geoTox

# Plot hill fits
plot(geoTox, type = "hill")
# Plot exposure data
plot(geoTox, type = "exposure", ncol = 5)
# Plot response data
plot(geoTox)
plot(geoTox, assays = "TOX21_H2AX_HTRF_CHO_Agonist_ratio")
# Plot sensitivity data
plot(geoTox, type = "sensitivity")
plot(geoTox, type = "sensitivity", assay = "TOX21_H2AX_HTRF_CHO_Agonist_ratio")
}
\seealso{
\link{plot_resp}, \link{plot_hill}, \link{plot_exposure}, \link{plot_sensitivity}
}
