% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_conc.R
\name{hill_conc}
\alias{hill_conc}
\title{Hill model concentration}
\usage{
hill_conc(resp, max, AC50, n)
}
\arguments{
\item{resp}{response value}

\item{max}{maximal (asymptotic) response}

\item{AC50}{concentration of half-maximal response}

\item{n}{Hill coefficient (slope)}
}
\value{
concentration in regular space
}
\description{
Calculate the concentration in regular space for a given response value.
}
\details{
This is a regular space version of
\href{https://cran.r-project.org/package=tcpl}{tcpl::tcplHillConc()}.

The concentration is computed as:
\deqn{conc = AC50 * (\frac{max}{resp} - 1)^{-1 / n}}
}
\examples{
hill_conc(c(0.2, 0.5, 0.75), 1, 0.01, 1)
hill_conc(c(0.2, 0.5, 0.9), 1, c(0.1, 0.01, 0.001), 2)
}
\seealso{
\code{\link{hill_val}}
}
