% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp_quantiles.R
\name{resp_quantiles}
\alias{resp_quantiles}
\title{Get response quantiles}
\usage{
resp_quantiles(
  resp,
  metric = c("GCA.Eff", "IA.Eff", "GCA.HQ.10", "IA.HQ.10"),
  assays = NULL,
  assay_summary = FALSE,
  assay_quantiles = c(Median = 0.5),
  summary_quantiles = c(`10th percentile` = 0.1)
)
}
\arguments{
\item{resp}{calculated mixture response output from
\link{calc_concentration_response}.}

\item{metric}{response metric, one of "GCA.Eff", "IA.Eff", "GCA.HQ.10"
or "IA.HQ.10".}

\item{assays}{assays to summarize. If NULL and multiple assays exist, then
the first assay is used.}

\item{assay_summary}{boolean indicating whether to summarize across assays.}

\item{assay_quantiles}{numeric vector of assay quantiles.}

\item{summary_quantiles}{numeric vector of quantiles to compute across all
assay quantiles.}
}
\value{
data frame with computed response quantiles.
}
\description{
Get response quantiles
}
\details{
The columns of the returned data frame will vary based on the inputs. If
assays is specified and assay_summary is FALSE, then the resulting data
frame will have an assay column. If assay_summary is TRUE, then the data
frame will have an summary_quantile column.
}
\examples{
# Dummy response data
resp <- list(
  "r1" = data.frame(assay = c("a1", "a1", "a2", "a2"),
                    sample = c(1, 2, 1, 2),
                    GCA.Eff = c(1, 2, 3, 4),
                    IA.Eff = c(5, 6, 7, 8),
                    "GCA.HQ.10" = c(9, 10, 11, 12),
                    "IA.HQ.10" = c(13, 14, 15, 16)))

# Summarize single assay
resp_quantiles(resp)
# Specify assay
resp_quantiles(resp, assays = "a1")
# Specify quantiles
resp_quantiles(resp, assays = "a1", assay_quantiles = c(0.25, 0.75))
# Specify metric
resp_quantiles(resp, assays = "a1", metric = "IA.HQ.10")

# Summarize across assays
resp_quantiles(resp, assay_summary = TRUE)
# Specify quantiles
suppressWarnings(
  resp_quantiles(resp,
                 assay_summary = TRUE,
                 assay_quantiles = c(0.25, 0.75),
                 summary_quantiles = c(0.1, 0.9))
)
}
