% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssa.btl.R
\name{ssa.btl}
\alias{ssa.btl}
\title{Binomial tau-leap method (BTL)}
\usage{
ssa.btl(f = 10)
}
\arguments{
\item{f}{coarse-graining factor (see page 4 in Chatterjee et al. 2005).}
}
\description{
Binomial tau-leap method implementation of the \acronym{SSA} as described by
Chatterjee et al. (2005). Should be passed as \code{method} argument for \code{ssa()}.
}
\details{
Performs one time step using the Binomial tau-leap method. Intended to be
invoked by \code{\link[=ssa]{ssa()}}.
}
\examples{
ssa.btl(f = 40)

}
\references{
Chatterjee et al. (2005)
}
\seealso{
\link{GillespieSSA-package}, \code{\link[=ssa]{ssa()}}
}
\keyword{datagen}
\keyword{misc}
\keyword{ts}
