% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeDesc.R
\name{mergeDesc}
\alias{mergeDesc}
\title{Prepares a matrix for \code{htmlTable} from a list}
\usage{
mergeDesc(..., htmlTable_args = list())
}
\arguments{
\item{...}{One or more elements coming from \code{\link{getDescriptionStatsBy}}.
You can also provide pure output from the \code{\link{getDescriptionStatsBy}} function
and have the function merge this together with the \code{...} argument.
\emph{Note} that all elements must have the same \code{by} argument or you
will not be able to merge it into a list.}

\item{htmlTable_args}{Any arguments that should be passed to
\code{\link[htmlTable]{htmlTable}} function. The default is to remove
any css formatting for the \code{rgroup}.}
}
\value{
\code{matrix} Returns a matrix object of class descList
}
\description{
By putting all the output from the \code{\link{getDescriptionStatsBy}}
into a list, naming each element that we want in an \code{rgroup} we can
automatically merge everything and create an object ready for the
\code{\link[htmlTable]{htmlTable}}.
}
\section{The \code{rgroup} value}{


The value for the \code{rgroup} is by default the name of the list element. If you have
passed a list without a name for that particular element or if you have passed a
matrix it will look for a label set by the \pkg{Hmisc}\code{::\link[Hmisc]{label}} function.
For those elements that have only one row no \code{rgroup} is set, and the naming sequence
is the same as above but with an additional \code{\link[base:colnames]{rownames}} if the previous
two turn out empty. All this behavior is exemplified in the example.

The \code{rgroup} value can be overridden by simply specifying a custom \code{rgroup} when
calling the \code{\link[htmlTable]{htmlTable}} function.
}

\section{The \code{colnames} of the matrix}{


The function chooses the \code{\link[base]{colnames}} from the first element in
the \code{tlist}.
}

\examples{
library(magrittr)
library(dplyr)
library(htmlTable)

data(mtcars)
mtcars \%<>\%
  mutate(am = factor(am, levels = 0:1, labels = c("Automatic", "Manual")),
         vs = factor(vs, levels = 0:1, labels = c("V-shaped", "straight")),
         drat_prop = drat > median(drat),
         drat_prop = factor(drat_prop,
                            levels = c(FALSE, TRUE),
                            labels = c("High ratio", "Low ratio")),
         carb_prop = carb > 2,
         carb_prop = factor(carb_prop,
                            levels = c(FALSE, TRUE),
                            labels = c("&le; 2", "&gt; 2")),
         across(c(gear, carb, cyl), factor))

# A simple bare-bone example
mtcars \%>\%
  getDescriptionStatsBy(`Miles per gallon` = mpg,
                        Weight = wt,
                        `Carborators &le; 2` = carb_prop,
                        by = am) \%>\%
  htmlTable(caption  = "Basic continuous stats from the mtcars dataset")
invisible(readline(prompt = "Press [enter] to continue"))

# For labeling & units we use set_column_labels/set_column_unit that use
# the Hmisc package annotation functions
mtcars \%<>\%
  set_column_labels(am = "Transmission",
                    mpg = "Gas",
                    wt = "Weight",
                    gear = "Gears",
                    disp = "Displacement",
                    vs = "Engine type",
                    drat_prop = "Rear axel ratio",
                    carb_prop = "Carburetors") \%>\%
  set_column_units(mpg = "Miles/(US) gallon",
                   wt = "10<sup>3</sup> lbs",
                   disp = "cu.in.")

mtcars \%>\%
  getDescriptionStatsBy(mpg,
                        wt,
                        `Gear&dagger;` = gear,
                        drat_prop,
                        carb_prop,
                        vs,
                        by = am,
                        header_count = TRUE,
                        use_units = TRUE,
                        show_all_values = TRUE)  \%>\%
  addHtmlTableStyle(pos.caption = "bottom") \%>\%
  htmlTable(caption  = "Stats from the mtcars dataset",
            tfoot = "&dagger; Number of forward gears")
invisible(readline(prompt = "Press [enter] to continue"))

# Using the default parameter we can
mtcars \%>\%
  getDescriptionStatsBy(mpg,
                        wt,
                        `Gear&dagger;` = gear,
                        drat_prop,
                        carb_prop,
                        vs,
                        by = am,
                        header_count = TRUE,
                        use_units = TRUE,
                        default_ref = c(drat_prop = "Low ratio",
                                        carb_prop = "&gt; 2"))  \%>\%
  addHtmlTableStyle(pos.caption = "bottom") \%>\%
  htmlTable(caption  = "Stats from the mtcars dataset",
            tfoot = "&dagger; Number of forward gears")
invisible(readline(prompt = "Press [enter] to continue"))

# We can also use lists
tll <- list()
tll[["Gear (3 to 5)"]] <- getDescriptionStatsBy(mtcars$gear, mtcars$am)
tll <- c(tll,
         list(getDescriptionStatsBy(mtcars$disp, mtcars$am)))

mergeDesc(tll,
          htmlTable_args = list(caption  = "Factored variables")) \%>\%
  htmlTable::addHtmlTableStyle(css.rgroup = "")
invisible(readline(prompt = "Press [enter] to continue"))

tl_no_units <- list()
tl_no_units[["Gas (mile/gallons)"]] <-
  getDescriptionStatsBy(mtcars$mpg, mtcars$am,
                        header_count = TRUE)
tl_no_units[["Weight (10<sup>3</sup> kg)"]] <-
  getDescriptionStatsBy(mtcars$wt, mtcars$am,
                        header_count = TRUE)
mergeDesc(tl_no_units,
          tll) \%>\%
  htmlTable::addHtmlTableStyle(css.rgroup = "")
invisible(readline(prompt = "Press [enter] to continue"))

# Other settings
mtcars$mpg[sample(1:NROW(mtcars), size = 5)] <- NA
getDescriptionStatsBy(mtcars$mpg,
                      mtcars$am,
                      statistics = TRUE)
invisible(readline(prompt = "Press [enter] to continue"))

# Do the horizontal version
getDescriptionStatsBy(mtcars$gear,
                      mtcars$am,
                      statistics = TRUE,
                      hrzl_prop = TRUE)
invisible(readline(prompt = "Press [enter] to continue"))

mtcars$wt_with_missing <- mtcars$wt
mtcars$wt_with_missing[sample(1:NROW(mtcars), size = 8)] <- NA
getDescriptionStatsBy(mtcars$wt_with_missing, mtcars$am, statistics = TRUE,
                      hrzl_prop = TRUE, total_col_show_perc = FALSE)
invisible(readline(prompt = "Press [enter] to continue"))

\dontrun{
  ## There is also a LaTeX wrapper
  tll <- list(
    getDescriptionStatsBy(mtcars$gear, mtcars$am),
    getDescriptionStatsBy(mtcars$col, mtcars$am))

  latex(mergeDesc(tll),
        caption  = "Factored variables",
        file = "")
}
}
\concept{table functions}
